% clear all; close all;


function [cell_loc path_c] = assign_path(cell_loc, count_pic, path_c, max_d, new_path)

    if isnan(cell_loc{count_pic,1})
        return
    end
    
    for count_point = 1:numel(cell_loc{count_pic,1}(:,1))
        if isnan(cell_loc{count_pic,1}(count_point,5));
            cell_loc{count_pic,1}(count_point,5) = path_c;
            path_c = path_c +1;
        end
    end
    
    if count_pic+1 <= size(cell_loc,1)
        num_cells_next_pic = numel(find(~isnan(cell_loc{count_pic+1,1}(:,1))));
    else
        return
    end
   
    if isnan(num_cells_next_pic)
        return
    else
        num_neighb = num_cells_next_pic;
    end
 
 
    [nearest_n, D] = knnsearch(cell_loc{count_pic,1}(:,1:2), cell_loc{count_pic+1,1}(:,1:2), num_neighb);
    for count_point = 1:size(D,1)
        where_close = (find(D(count_point,:) <= max_d));
        if new_path
            if nnz(where_close) == 1 %You have only continuous paths if there is only one cell in the search radius.
                cell_loc{count_pic+1,1}(nearest_n(count_point,where_close(1,1)),5) = cell_loc{count_pic,1}(count_point,5);
            end
        else
            if nnz(where_close) >= 1 %Paths are continued to the nearest center in the search radius.
                cell_loc{count_pic+1,1}(nearest_n(count_point,where_close(1,1)),5) = cell_loc{count_pic,1}(count_point,5);
            end
        end
    end